namespace Robotless.Modules.Injecting;

[AttributeUsage(AttributeTargets.Field | AttributeTargets.Property | AttributeTargets.Parameter)]
public class InjectionAttribute(Type? type = null) : Attribute
{
    /// <summary>
    /// If true, then injector should throw an exception if this injection is not found.
    /// It is false by default.
    /// </summary>
    public bool IsRequired { get; init; } = false;

    /// <summary>
    /// Type for the injection to request.
    /// </summary>
    public Type? Type { get; init; } = type;
    
    /// <summary>
    /// Key for the injection to request.
    /// </summary>
    public object? Key { get; init; } = null;
}
