namespace Robotless.Modules.Injecting;

public partial class InjectionContainer
{
    private class ConstantInjectionEntry(object value) : IInjectionEntry
    {
        public InjectionLifespan Lifespan => InjectionLifespan.Singleton;

        public object Value => value;
    }

    private class FactoryInjectionEntry(Func<IInjectionProvider, InjectionRequester, object> factory) : IInjectionEntry
    {
        public required InjectionLifespan Lifespan { get; init; }

        public Func<IInjectionProvider, InjectionRequester, object> Factory => factory;
    }

    private class TypeInjectionEntry(Type implementation) : IInjectionEntry
    {
        public required InjectionLifespan Lifespan { get; init; }

        public Type Implementation => implementation;
    }

    private class RedirectionEntry(Type targetType, object? targetKey) : IInjectionEntry
    {
        public InjectionLifespan Lifespan => InjectionLifespan.Transient;
        
        public Type TargetType => targetType;
        
        public object? TargetKey => targetKey;
    }
}