using Microsoft.Extensions.Logging;
using MongoDB.Bson;
using MongoDB.Bson.IO;
using MongoDB.Driver;
using Robotless.Modules.Injecting;
using Robotless.Modules.Serializing;

namespace Robotless.Modules.Logging.Handlers;

/// <summary>
/// This log handler will submit logs to a MongoDB collection.
/// </summary>
/// <param name="collection">Collection to submit to.</param>
/// <param name="serializer">Serialization provider to serialize logs.</param>
public class DatabaseUploader(
    IMongoCollection<BsonDocument> collection, ISerializationProvider serializer) : ILogHandler
{
    public LogLevel MinimumLevel { get; set; } = LogLevel.Trace;

    private readonly ISnapshotSerializer<LogItem> _serializer =
        serializer.RequireSerializer<LogItem>();
    
    public void HandleLog(LogItem log)
    {
        if (log.Level < MinimumLevel)
            return;
        var document = new BsonDocument();
        _serializer.SaveSnapshot(log, new BsonDocumentWriter(document));
        collection.InsertOne(document);
    }
}