﻿namespace Robotless.Modules.Logging;

public class LogScope(Action<LogScope>? onDisposed = null) : IDisposable
{
    public required string Message { get; init; }
    
    public required DateTime BeginningTime { get; init; }

    public DateTime EndingTime { get; private set; }

    public LogScope? UpperScope { get; init; }

    public bool IsOngoing { get; private set; } = true;

    public void Dispose()
    {
        if (IsOngoing == false)
            return;
        IsOngoing = false;
        EndingTime = DateTime.Now;
        onDisposed?.Invoke(this);
    }
}