﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing;

/// <summary>
/// Serializers generated by serializer generator cannot access private or protected members,
/// but users can implement this interface to customize the serialization process.
/// Methods declared in this interface will be invoked by the generated serializers after
/// the generated methods have loaded or saved the snapshot.
/// </summary>
public interface ICustomizedSerialization
{
    /// <summary>
    /// Write the schema of the snapshot into the specified writer.
    /// </summary>
    /// <param name="schema">Writer to write schema into.</param>
    static virtual void GenerateJsonSchema(SchemaWriter schema)
    {}
    
    /// <summary>
    /// This method will be invoked in the generated snapshot serializer after
    /// the generated method has loaded the snapshot.
    /// </summary>
    /// <param name="reader">Read to read the snapshot.</param>
    /// <param name="context">Serialization context.</param>
    void OnLoadSnapshot(SnapshotReader reader, ISerializationProvider context);

    /// <summary>
    /// This method will be invoked in the generated snapshot serializer after
    /// the generated method has saved the snapshot.
    /// </summary>
    /// <param name="writer">Writer to write the snapshot.</param>
    /// <param name="context">Serialization context.</param>
    void OnSaveSnapshot(IBsonWriter writer, ISerializationProvider context);
}