namespace Robotless.Modules.Serializing;

public interface ISerializationContext : ISerializationProvider
{
    /// <summary>
    /// Fallback providers to query if this context does not have a serializer for the specified target type.
    /// </summary>
    ICollection<ISerializerTypeProvider> TypeProviders { get; }
    
    /// <summary>
    /// Bind the serializer type to the target type.
    /// </summary>
    /// <param name="targetType">Target type to serialize.</param>
    /// <param name="serializerType">Serializer type to bind.</param>
    void SetSerializer(Type targetType, Type serializerType);
}

public static class SerializationContextExtensions
{
    public static ISerializationContext WithSerializer<TTarget, TSerializer>(this ISerializationContext context)
    {
        context.SetSerializer(typeof(TTarget), typeof(TSerializer));
        return context;
    }
}