namespace Robotless.Modules.Serializing;

/// <summary>
/// Serializer type provider can choose serializer type according to a more customizable logic.
/// </summary>
public interface ISerializerTypeProvider
{
    /// <summary>
    /// Try to get the type of the serializer for the specified target type.
    /// </summary>
    /// <param name="targetType">Target type to serialize.</param>
    /// <returns>Serializer type, or null if not found.</returns>
    Type? GetSerializerType(Type targetType);
}