﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using MongoDB.Bson.Serialization;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.BsonValues;

public class BsonDocumentSerializer : ISnapshotSerializer<BsonDocument>
{
    public required ISerializationProvider Context { get; init; }
    
    public void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Object);
    }

    public void NewInstance(out BsonDocument target)
    {
        target = new BsonDocument();
    }

    public void LoadSnapshot(ref BsonDocument target, SnapshotReader reader)
    {
        target = BsonSerializer.Deserialize<BsonDocument>(reader);
    }

    private static readonly BsonSerializationArgs Settings = new()
    {
        NominalType = typeof(BsonDocument),
        SerializeAsNominalType = true
    };

    public void SaveSnapshot(in BsonDocument target, IBsonWriter writer)
    {
        BsonSerializer.Serialize(writer, typeof(BsonDocument), target, args: Settings);
    }
}