﻿using MongoDB.Bson;

namespace Robotless.Modules.Serializing.Serializers.BsonValues;

public class BsonValueSerializerProvider : ISerializerTypeProvider
{
    public Type? GetSerializerType(Type targetType)
    {
        if (targetType.IsAssignableTo(typeof(BsonValue)))
            return typeof(BsonValueSerializerAdapter<>).MakeGenericType(targetType);
        return null;
    }
}

public static class BsonValueProviderExtensions
{
    public static TSerializationContext WithBsonValueSerializers<TSerializationContext>(
        this TSerializationContext context)
        where TSerializationContext : SerializationContext
    {
        context.WithSerializer<BsonDocument, BsonDocumentSerializer>();
        context.WithSerializer<BsonValue, BsonValueSerializer>();

        context.TypeProviders.Add(new BsonValueSerializerProvider());
        return context;
    }
}