﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using MongoDB.Bson.Serialization;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.BsonValues;

public class BsonValueSerializer : ISnapshotSerializer<BsonValue>
{
    public required ISerializationProvider Context { get; init; }
    
    public void GenerateJsonSchema(SchemaWriter schema)
    {
        // At this time, the actual type of BsonValue is unknown.
    }

    public void NewInstance(out BsonValue target)
    {
        target = BsonNull.Value;
    }

    public void LoadSnapshot(ref BsonValue target, SnapshotReader reader)
    {
        target = BsonSerializer.Deserialize<BsonValue>(reader);
    }

    public void SaveSnapshot(in BsonValue target, IBsonWriter writer)
    {
        BsonSerializer.Serialize(writer, target);
    }
}