﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using MongoDB.Bson.Serialization;
using Robotless.Modules.Serializing.Serializers.Primitives;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.BsonValues;

public class BsonValueSerializerAdapter<TBsonValue> : 
    PrimitiveSerializerBase<TBsonValue> where TBsonValue : BsonValue
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        var type = typeof(TBsonValue);
        
        if (type == typeof(BsonDocument))
        {
            schema.DefineType(SchemaType.Object);
        } 
        else if (type == typeof(BsonBoolean))
        {
            schema.DefineType(SchemaType.Boolean);
        }
        else if (type == typeof(BsonString))
        {
            schema.DefineType(SchemaType.String);
        } 
        else if (type == typeof(BsonArray))
        {
            schema.DefineType(SchemaType.Array);
        } 
        else if (type == typeof(BsonInt32) || type == typeof(BsonInt64))
        {
            schema.DefineType(SchemaType.Integer);
        } 
        else if (type == typeof(BsonDouble))
        {
            schema.DefineType(SchemaType.Number);
        } 
        else if (type == typeof(BsonNull))
        {
            schema.DefineType(SchemaType.Null);
        }
    }

    protected override void OnLoadSnapshot(ref TBsonValue target, SnapshotReader reader)
    {
        target = BsonSerializer.Deserialize<TBsonValue>(reader);
    }

    protected override void OnSaveSnapshot(in TBsonValue target, IBsonWriter writer)
    {
        BsonSerializer.Serialize(writer, target);
    }
}