﻿using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class CollectionSerializer<TElement>(ISnapshotSerializer<TElement> elementSerializer)
    : ContainerSerializerBase<TElement, ICollection<TElement>>
{
    protected override ISnapshotSerializer<TElement> ElementSerializer { get; } = elementSerializer;

    /// <summary>
    /// Instantiate a new instance of <see cref="List{TElement}"/>.
    /// </summary>
    public override void NewInstance(out ICollection<TElement> target)
    {
        target = new List<TElement>();
    }

    private static readonly bool IsValueType = typeof(TElement).IsValueType;

    /// <summary>
    /// If <typeparamref name="TElement"/> is a value type, then this serializer will
    /// use <see cref="ICollection{T}.Clear"/> and <see cref="ICollection{T}.Add"/>
    /// of <see cref="ICollection{T}"/> to load snapshot, elements of the target collection will be replaced.
    /// <br/>
    /// If <typeparamref name="TElement"/> is a reference type, then this serializer will
    /// load snapshot into existing elements, and add new elements within the snapshot
    /// to the target collection.
    /// </summary>
    protected override void OnLoadSnapshot(ref ICollection<TElement> target, SnapshotReader reader)
    {
        if (target is IList<TElement> list)
        {
            ListLoader<TElement>.Load(list, reader, ElementSerializer);
            return;
        }
        
        if (IsValueType)
        {
            CollectionOfValueLoader<TElement>.Load(target, reader, ElementSerializer);
            return;
        }
        
        CollectionOfReferenceLoader<TElement>.Load(target, reader, ElementSerializer);
    }
}