﻿using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

/// <summary>
/// This serializer will use <see cref="List{T}"/> as the underlying type to deserialize snapshot.
/// It will try to load snapshot into the element at the same index,
/// and if the index is out of range, it will create a new element and add it to the target list.
/// </summary>
public class EnumerableSerializer<TElement>(ISnapshotSerializer<TElement> elementSerializer) :
    ContainerSerializerBase<TElement, IEnumerable<TElement>>
{
    protected override ISnapshotSerializer<TElement> ElementSerializer { get; } = elementSerializer;

    public override void NewInstance(out IEnumerable<TElement> target)
    {
        target = new List<TElement>();
    }
    
    protected override void OnLoadSnapshot(ref IEnumerable<TElement> target, SnapshotReader reader)
    {
        if (target is not IList<TElement> list)
            list = [..target];

        ListLoader<TElement>.Load(list, reader, ElementSerializer);
    }
}