﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class KeyValuePairSerializer<TKey, TValue>(
    ISnapshotSerializer<TKey> keySerializer,
    ISnapshotSerializer<TValue> valueSerializer) :
    ISnapshotSerializer<KeyValuePair<TKey, TValue>>
{
    public required ISerializationProvider Context { get; init; }
    
    public void NewInstance(out KeyValuePair<TKey, TValue> target)
    {
        target = default;
    }

    public void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Object);
        using (schema.DefinePropertiesScope())
        {
            schema.DefineEmbeddedSchema("!Key", keySerializer);
            schema.DefineEmbeddedSchema("!Value", valueSerializer);
        }
        schema.DefineRequiredProperties("!Key", "!Value");
    }

    public void LoadSnapshot(ref KeyValuePair<TKey, TValue> target, SnapshotReader reader)
    {
        if (reader.GetCurrentBsonType() == BsonType.Null)
            target = default;
        
        KeyValuePairLoader<TKey, TValue>.Load(
            out target, reader, keySerializer, valueSerializer);
    }

    public void SaveSnapshot(in KeyValuePair<TKey, TValue> target, IBsonWriter writer)
    {
        KeyValuePairSaver<TKey, TValue>.Save(target, writer, keySerializer, valueSerializer);
    }
}