﻿using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class ListSerializer<TElement>(ISnapshotSerializer<TElement> elementSerializer) :
    ContainerSerializerBase<TElement, IList<TElement>>
{
    protected override ISnapshotSerializer<TElement> ElementSerializer { get; } = elementSerializer;

    public override void NewInstance(out IList<TElement> target)
    {
        target = new List<TElement>();
    }

    /// <summary>
    /// It will try to load snapshot into the element at the same index,
    /// and if the index is out of range, it will create a new element and add it to the target list.
    /// </summary>
    protected override void OnLoadSnapshot(ref IList<TElement> target, SnapshotReader reader)
    {
        if (target == null!)
            target = [];
        ListLoader<TElement>.Load(target, reader, ElementSerializer);
    }
}