﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class ReadOnlyStringDictionarySerializer<TValue>(
    ISnapshotSerializer<TValue> valueSerializer) : ISnapshotSerializer<IReadOnlyDictionary<string, TValue>>
{
    public required ISerializationProvider Context { get; init; }

    public void NewInstance(out IReadOnlyDictionary<string, TValue> target)
    {
        target = new Dictionary<string, TValue>();
    }

    public void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineEmbeddedSchema("additionalProperties", valueSerializer);
    }

    public void LoadSnapshot(ref IReadOnlyDictionary<string, TValue> target, SnapshotReader reader)
    {
        if (reader.GetCurrentBsonType() == BsonType.EndOfDocument)
            target = null!;
        if (target is not IDictionary<string, TValue> dictionary)
            dictionary = new Dictionary<string, TValue>();
        StringDictionaryLoader<TValue>.Load(dictionary, reader, valueSerializer);
    }

    public void SaveSnapshot(in IReadOnlyDictionary<string, TValue> target, IBsonWriter writer)
    {
        if (target == null!)
        {
            writer.WriteNull();
            return;
        }
        StringDictionarySaver<TValue>.Save(target, writer, valueSerializer);
    }
}