﻿using MongoDB.Bson;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public abstract class CollectionOfReferenceLoader<TElement> : IContainerLoader<TElement, ICollection<TElement>>
{
    public static void Load(ICollection<TElement> target, SnapshotReader reader, 
        ISnapshotSerializer<TElement> elementSerializer)
    {
        using (reader.ArrayScope())
        {
            using var enumerator = target.GetEnumerator();
            while (enumerator.MoveNext())
            {
                while (reader.ReadBsonType() != BsonType.EndOfDocument)
                {
                    var element = enumerator.Current;
                    elementSerializer.LoadSnapshot(ref element, reader);
                }
            }
            while (reader.ReadBsonType() != BsonType.EndOfDocument)
            {
                elementSerializer.NewInstance(out var element);
                elementSerializer.LoadSnapshot(ref element, reader);
                target.Add(element);
            }
        }
    }
}