﻿using MongoDB.Bson;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public class CollectionOfValueLoader<TElement> : IContainerLoader<TElement, ICollection<TElement>>
{
    public static void Load(ICollection<TElement> target, SnapshotReader reader,
        ISnapshotSerializer<TElement> elementSerializer)
    {
        target.Clear();
        using (reader.ArrayScope())
        {
            while (reader.ReadBsonType() != BsonType.EndOfDocument)
            {
                elementSerializer.NewInstance(out var element);
                elementSerializer.LoadSnapshot(ref element, reader);
                target.Add(element);
            }
        }
    }
}