﻿using MongoDB.Bson;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public static class DictionaryLoader<TKey, TValue>
{
    public static void Load(IDictionary<TKey, TValue> dictionary, SnapshotReader reader,
        ISnapshotSerializer<TKey> keySerializer, ISnapshotSerializer<TValue> valueSerializer)
    {
        dictionary.Clear();
        using (reader.ArrayScope())
        {
            while (reader.ReadBsonType() != BsonType.EndOfDocument)
            {
                KeyValuePairLoader<TKey,TValue>.Load(out var pair, reader, keySerializer, valueSerializer);
                dictionary[pair.Key] = pair.Value;
            }
        }
    }
}