﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public class DictionarySaver<TKey, TValue>
{
    public static void Save(IEnumerable<KeyValuePair<TKey, TValue>> dictionary, IBsonWriter writer,
        ISnapshotSerializer<TKey> keySerializer, ISnapshotSerializer<TValue> valueSerializer)
    {
        using (writer.ArrayScope())
        {
            foreach (var pair in dictionary)
            {
                KeyValuePairSaver<TKey,TValue>.Save(pair, writer, keySerializer, valueSerializer);
            }
        }
    }
}