﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public abstract class EnumerableSaver<TElement> : IContainerSaver<TElement, IEnumerable<TElement>>
{
    public static void Save(IEnumerable<TElement> target, IBsonWriter writer, ISnapshotSerializer<TElement> elementSerializer)
    {
        using (writer.ArrayScope())
        {
            foreach (var element in target)
            {
                elementSerializer.SaveSnapshot(element, writer);
            }
        }
    }
}