﻿using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public static class KeyValuePairLoader<TKey, TValue>
{
    public static void Load(out KeyValuePair<TKey, TValue> pair, SnapshotReader reader, 
        ISnapshotSerializer<TKey> keySerializer, ISnapshotSerializer<TValue> valueSerializer)
    {
        using (reader.DocumentScope())
        {
            reader.Locate("!Key");
            keySerializer.NewInstance(out var key);
            keySerializer.LoadSnapshot(ref key, reader);
            reader.Locate("!Value");
            valueSerializer.NewInstance(out var value);
            valueSerializer.LoadSnapshot(ref value, reader);

            pair = new KeyValuePair<TKey, TValue>(key, value);
        }
    }
}