﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public static class KeyValuePairSaver<TKey, TValue>
{
    public static void Save(in KeyValuePair<TKey, TValue> pair, IBsonWriter writer, 
        ISnapshotSerializer<TKey> keySerializer, ISnapshotSerializer<TValue> valueSerializer)
    {
        using (writer.DocumentScope())
        {
            writer.WriteName("!Key");
            keySerializer.SaveSnapshot(pair.Key, writer);
            writer.WriteName("!Value");
            valueSerializer.SaveSnapshot(pair.Value, writer);
        }
    }
}