﻿using MongoDB.Bson;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public abstract class ListLoader<TElement> : IContainerLoader<TElement, IList<TElement>>
{
    public static void Load(IList<TElement> target, SnapshotReader reader, ISnapshotSerializer<TElement> elementSerializer)
    {
        using (reader.ArrayScope())
        {
            var index = 0;
            while (reader.ReadBsonType() != BsonType.EndOfDocument)
            {
                if (index < target.Count)
                {
                    var element = target[index];
                    elementSerializer.LoadSnapshot(ref element, reader);
                    target[index] = element;
                }
                else
                {
                    elementSerializer.NewInstance(out var element);
                    elementSerializer.LoadSnapshot(ref element, reader);
                    target.Add(element);
                }
                
                index++;
            }
        }
    }
}