﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public static class StringDictionaryLoader<TValue>
{
    public static void Load(IDictionary<string, TValue> dictionary, SnapshotReader reader,
        ISnapshotSerializer<TValue> valueSerializer)
    {
        dictionary.Clear();
        reader.ReadStartDocument();
        while (reader.ReadBsonType() != BsonType.EndOfDocument)
        {
            var name = reader.ReadName();
            valueSerializer.NewInstance(out var value);
            valueSerializer.LoadSnapshot(ref value, reader);
            dictionary[name] = value;
        }
        reader.ReadEndDocument();
    }
}