﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;

public class StringDictionarySaver<TValue>
{
    public static void Save(IEnumerable<KeyValuePair<string, TValue>> dictionary, IBsonWriter writer,
        ISnapshotSerializer<TValue> valueSerializer)
    {
        writer.WriteStartDocument();
        foreach (var pair in dictionary)
        {
            writer.WriteName(pair.Key);
            valueSerializer.SaveSnapshot(pair.Value, writer);
        }
        writer.WriteEndDocument();
    }
}