﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class StringDictionarySerializer<TValue>(
    ISnapshotSerializer<TValue> valueSerializer) : ISnapshotSerializer<IDictionary<string, TValue>>
{
    public required ISerializationProvider Context { get; init; }

    public void NewInstance(out IDictionary<string, TValue> target)
    {
        target = new Dictionary<string, TValue>();
    }

    public void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineEmbeddedSchema("additionalProperties", valueSerializer);
    }

    public void LoadSnapshot(ref IDictionary<string, TValue> target, SnapshotReader reader)
    {
        if (reader.GetCurrentBsonType() == BsonType.EndOfDocument)
            target = null!;
        StringDictionaryLoader<TValue>.Load(target, reader, valueSerializer);
    }

    public void SaveSnapshot(in IDictionary<string, TValue> target, IBsonWriter writer)
    {
        if (target == null!)
        {
            writer.WriteNull();
            return;
        }
        StringDictionarySaver<TValue>.Save(target, writer, valueSerializer);
    }
}