﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Serializers.Containers.SharedImplementation;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Containers;

public class StringValuePairSerializer<TValue>(ISnapshotSerializer<TValue> valueSerializer) :
    ISnapshotSerializer<KeyValuePair<string, TValue>>
{
    public required ISerializationProvider Context { get; init; }
    
    public void NewInstance(out KeyValuePair<string, TValue> target)
    {
        target = default;
    }

    public void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineEmbeddedSchema("additionalProperties", valueSerializer);
    }

    public void LoadSnapshot(ref KeyValuePair<string, TValue> target, SnapshotReader reader)
    {
        reader.ReadStartDocument();
        var name = reader.ReadName();
        valueSerializer.NewInstance(out var value);
        valueSerializer.LoadSnapshot(ref value, reader);
        target = new KeyValuePair<string, TValue>(name, value);
        reader.ReadEndDocument();
    }

    public void SaveSnapshot(in KeyValuePair<string, TValue> target, IBsonWriter writer)
    {
        writer.WriteStartDocument();
        writer.WriteName(target.Key);
        valueSerializer.SaveSnapshot(target.Value, writer);
        writer.WriteEndDocument();
    }
}