﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class BooleanSerializer : PrimitiveSerializerBase<bool>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Boolean);
    }

    protected override void OnLoadSnapshot(ref bool target, SnapshotReader reader)
    {
        target = reader.ReadBoolean();
    }

    protected override void OnSaveSnapshot(in bool target, IBsonWriter writer)
    {
        writer.WriteBoolean(target);
    }
}