﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class BytesSerializer : PrimitiveSerializerBase<byte[]>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        // It is recommended to represent byte[] as base64 string in JSON.
        schema.DefineType(SchemaType.String);
        schema.DefineDescription("Base64 encoded byte array");
    }

    protected override void OnLoadSnapshot(ref byte[] target, SnapshotReader reader)
    {
        target = reader.ReadBytes();
    }

    protected override void OnSaveSnapshot(in byte[] target, IBsonWriter writer)
    {
        writer.WriteBytes(target);
    }
}