﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class DateTimeSerializer : PrimitiveSerializerBase<DateTime>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Integer);
        schema.DefineDescription("Unix timestamp in milliseconds.");
    }

    protected override void OnLoadSnapshot(ref DateTime target, SnapshotReader reader)
    {
        target = DateTime.UnixEpoch + TimeSpan.FromMilliseconds(reader.ReadDateTime());
    }

    protected override void OnSaveSnapshot(in DateTime target, IBsonWriter writer)
    {
        writer.WriteDateTime((long)(target - DateTime.UnixEpoch).TotalMilliseconds);
    }
}