﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;
using Enum = System.Enum;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class EnumSerializer<TEnum> : PrimitiveSerializerBase<TEnum> where TEnum : Enum
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.String);
        using (schema.DefineEnum())
        {
            foreach (var name in Enum.GetNames(typeof(TEnum)))
                schema.WriteString(name);
        }
    }

    protected override void OnLoadSnapshot(ref TEnum target, SnapshotReader reader)
    {
        target = (TEnum)Enum.Parse(typeof(TEnum), reader.ReadString());
    }

    protected override void OnSaveSnapshot(in TEnum target, IBsonWriter writer)
    {
        writer.WriteString(target.ToString());
    }
}

public class EnumSerializerProvider : ISerializerTypeProvider
{
    public Type? GetSerializerType(Type targetType)
    {
        return targetType.IsAssignableTo(typeof(Enum)) ? typeof(EnumSerializer<>).MakeGenericType(targetType) : null;
    }
}