﻿using MongoDB.Bson;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class DoubleSerializer : PrimitiveSerializerBase<double>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Number);
    }
    
    protected override void OnLoadSnapshot(ref double target, SnapshotReader reader)
    {
        target = reader.CurrentBsonType switch
        {
            BsonType.Double => reader.ReadDouble(),
            BsonType.Int32 => reader.ReadInt32(),
            BsonType.Int64 => reader.ReadInt64(),
            _ => throw new InvalidCastException(
                $"Cannot deserialize {reader.CurrentBsonType} to {typeof(double)}")
        };
    }

    protected override void OnSaveSnapshot(in double target, IBsonWriter writer)
    {
        writer.WriteDouble(target);
    }
}

public class FloatSerializer : PrimitiveSerializerBase<float>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.Number);
    }
    
    protected override void OnLoadSnapshot(ref float target, SnapshotReader reader)
    {
        target = reader.CurrentBsonType switch
        {
            BsonType.Double => (float)reader.ReadDouble(),
            BsonType.Int32 => reader.ReadInt32(),
            BsonType.Int64 => reader.ReadInt64(),
            _ => throw new InvalidCastException(
                $"Cannot deserialize {reader.CurrentBsonType} to {typeof(double)}")
        };
    }

    protected override void OnSaveSnapshot(in float target, IBsonWriter writer)
    {
        writer.WriteDouble(target);
    }
}