﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class GuidSerializer : PrimitiveSerializerBase<Guid>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.String);
    }

    protected override void OnLoadSnapshot(ref Guid target, SnapshotReader reader)
    {
        target = Guid.Parse(reader.ReadString());
    }

    protected override void OnSaveSnapshot(in Guid target, IBsonWriter writer)
    {
        writer.WriteString(target.ToString("D"));
    }
}