﻿using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class NullableValueSerializer<TElement>(ISnapshotSerializer<TElement> elementSerializer) : 
    ISnapshotSerializer<TElement?> where TElement : struct
{
    public required ISerializationProvider Context { get; init; }
    
    public void NewInstance(out TElement? target)
    {
        target = default;
    }

    public void GenerateJsonSchema(SchemaWriter schema)
    {
        elementSerializer.GenerateJsonSchema(schema);
    }

    public void LoadSnapshot(ref TElement? target, SnapshotReader reader)
    {
        elementSerializer.NewInstance(out var element);
        elementSerializer.LoadSnapshot(ref element, reader);
        target = element;
    }

    public void SaveSnapshot(in TElement? target, IBsonWriter writer)
    {
        if (target.HasValue)
            elementSerializer.SaveSnapshot(target.Value, writer);
        else
            writer.WriteNull();
    }
}