﻿namespace Robotless.Modules.Serializing.Serializers.Primitives;

public static class PrimitiveSerializerExtensions
{
    /// <summary>
    /// Add primitive serializers to the specified context.
    /// </summary>
    /// <param name="context">Context to add serializers to.</param>
    /// <typeparam name="TSerializationContext">
    /// Type of the specified serialization context.
    /// </typeparam>
    /// <returns>
    /// The same context passed as parameter '<paramref name="context"/>', for method chaining.
    /// </returns>
    public static TSerializationContext WithPrimitiveSerializers<TSerializationContext>(
        this TSerializationContext context) where TSerializationContext : SerializationContext
    {
        context.WithSerializer<byte, IntegerUnsigned8Serializer>();
        context.WithSerializer<sbyte, Integer8Serializer>();
        context.WithSerializer<short, Integer16Serializer>();
        context.WithSerializer<ushort, IntegerUnsigned16Serializer>();
        context.WithSerializer<int, Integer32Serializer>();
        context.WithSerializer<uint, IntegerUnsigned32Serializer>();
        context.WithSerializer<long, Integer64Serializer>();
        context.WithSerializer<ulong, IntegerUnsigned64Serializer>();
        
        context.WithSerializer<float, FloatSerializer>();
        context.WithSerializer<double, DoubleSerializer>();
        
        context.WithSerializer<bool, BooleanSerializer>();
        context.WithSerializer<byte[], BytesSerializer>();
        context.WithSerializer<string, StringSerializer>();
        
        context.WithSerializer<Type, TypeSerializer>();
        context.WithSerializer<object, ObjectSerializer>();
        context.WithSerializer<Guid, GuidSerializer>();
        context.WithSerializer<DateTime, DateTimeSerializer>();

        context.SetSerializer(typeof(Nullable<>), typeof(NullableValueSerializer<>));
        
        context.TypeProviders.Add(new EnumSerializerProvider());
        
        return context;
    }
}