﻿using System.Runtime.CompilerServices;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class StringSerializer : PrimitiveSerializerBase<string>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.String);
    }
    
    protected override void OnLoadSnapshot(ref string target, SnapshotReader reader)
    {
        target = reader.ReadString();
    }

    protected override void OnSaveSnapshot(in string target, IBsonWriter writer)
    {
        writer.WriteString(target);
    }
}