﻿using System.Reflection;
using MongoDB.Bson.IO;
using Robotless.Modules.Serializing.Utilities;

namespace Robotless.Modules.Serializing.Serializers.Primitives;

public class TypeSerializer : PrimitiveSerializerBase<Type>
{
    public override void GenerateJsonSchema(SchemaWriter schema)
    {
        schema.DefineType(SchemaType.String);
    }

    protected override void OnLoadSnapshot(ref Type target, SnapshotReader reader)
    {
        var qualifiedName = reader.ReadString().Split(",");

        if (qualifiedName.Length == 1)
        {
            target = Type.GetType(qualifiedName[0]) ?? 
                throw new Exception($"Failed to load type \"{qualifiedName[0]}\" within the snapshot.");
            return;
        }
        
        var assembly = Assembly.Load(qualifiedName[1]);
        target = assembly.GetType(qualifiedName[0]) ??
            throw new Exception($"Failed to load type \"{qualifiedName[0]}\" within the snapshot.");
    }

    protected override void OnSaveSnapshot(in Type target, IBsonWriter writer)
    {
        if (target.Assembly.IsDynamic)
            throw new Exception("Cannot save dynamic types to the snapshot.");
        var assemblyName = target.Assembly.GetName().Name;
        writer.WriteString(assemblyName == "System.Private.CoreLib" ?
            target.FullName : target.AssemblyQualifiedName);
    }
}