﻿namespace Robotless.Modules.Serializing;

/// <summary>
/// Designate a snapshot serializer to be used for the type marked with this attribute.
/// </summary>
/// <param name="serializerType">Type of the designated snapshot serializer.</param>
public class UsingSnapshotSerializerAttribute(Type serializerType) : Attribute
{
    public readonly Type SerializerType = serializerType;
}

/// <summary>
/// Designate a snapshot serializer to be used for the type marked with this attribute.
/// </summary>
/// <typeparam name="TSerializer">Type of the designated snapshot serializer.</typeparam>
public class UsingSnapshotSerializerAttribute<TSerializer>() : UsingSnapshotSerializerAttribute(typeof(TSerializer))
    where TSerializer : ISnapshotSerializer
{}