﻿using MongoDB.Bson.IO;

namespace Robotless.Modules.Serializing.Utilities;

public static class BsonReaderExtensions
{
    public readonly ref struct BsonReaderArrayScope : IDisposable
    {
        public IBsonReader Reader { get; }
        
        public BsonReaderArrayScope(IBsonReader reader)
        {
            reader.ReadStartArray();
            Reader = reader;
        }

        public void Dispose()
        {
            Reader.ReadEndArray();
        }
    }

    public readonly ref struct BsonReaderDocumentScope : IDisposable
    {
        public IBsonReader Reader { get; }
        
        public BsonReaderDocumentScope(IBsonReader reader)
        {
            Reader = reader;
            reader.ReadStartDocument();
        }

        public void Dispose()
        {
            Reader.ReadEndDocument();
        }
    }
    
    public static BsonReaderArrayScope ArrayScope(this IBsonReader reader)
    {
        return new BsonReaderArrayScope(reader);
    }
    
    public static BsonReaderDocumentScope DocumentScope(this IBsonReader reader)
    {
        return new BsonReaderDocumentScope(reader);
    }
}