﻿using MongoDB.Bson.IO;

namespace Robotless.Modules.Serializing.Utilities;

public static class BsonWriterExtensions
{
    public readonly ref struct BsonWriterArrayScope : IDisposable
    {
        public IBsonWriter Writer { get; }
        
        public BsonWriterArrayScope(IBsonWriter writer)
        {
            writer.WriteStartArray();
            Writer = writer;
        }

        public void Dispose()
        {
            Writer.WriteEndArray();
        }
    }

    public readonly ref struct BsonWriterDocumentScope : IDisposable
    {
        public IBsonWriter Writer { get; }
        
        public BsonWriterDocumentScope(IBsonWriter writer)
        {
            Writer = writer;
            writer.WriteStartDocument();
        }

        public void Dispose()
        {
            Writer.WriteEndDocument();
        }
    }
    
    public static BsonWriterArrayScope ArrayScope(this IBsonWriter writer)
    {
        return new BsonWriterArrayScope(writer);
    }
    
    public static BsonWriterDocumentScope DocumentScope(this IBsonWriter writer)
    {
        return new BsonWriterDocumentScope(writer);
    }
}