﻿using System.ComponentModel;

namespace Robotless.Modules.Serializing.Utilities;

public enum SchemaType
{
    String,
    Number,
    Integer,
    Object,
    Array,
    Boolean,
    Null
}

public static class SchemaTypeConverter
{
    public static string ToSchemaString(this SchemaType type) => type switch
    {
        SchemaType.String => "string",
        SchemaType.Number => "number",
        SchemaType.Integer => "integer",
        SchemaType.Object => "object",
        SchemaType.Array => "array",
        SchemaType.Boolean => "boolean",
        SchemaType.Null => "null",
        _ => throw new InvalidEnumArgumentException("Invalid schema type.")
    };
    
    public static SchemaType Parse(string type) => type.ToLower() switch
    {
        "string" => SchemaType.String,
        "number" => SchemaType.Number,
        "integer" => SchemaType.Integer,
        "object" => SchemaType.Object,
        "array" => SchemaType.Array,
        "boolean" => SchemaType.Boolean,
        "null" => SchemaType.Null,
        _ => throw new InvalidEnumArgumentException("Invalid schema type.")
    };
    
    public static SchemaType? TryParse(string type) => type.ToLower() switch
    {
        "string" => SchemaType.String,
        "number" => SchemaType.Number,
        "integer" => SchemaType.Integer,
        "object" => SchemaType.Object,
        "array" => SchemaType.Array,
        "boolean" => SchemaType.Boolean,
        "null" => SchemaType.Null,
        _ => null
    };
}

