﻿// namespace Robotless.Modules.Serializing.Utilities;
//
// public class SerializerGeneratorCache(SerializerGenerator generator) : ISerializerTypeProvider
// {
//     private readonly Dictionary<Type, Type> _cachedTypes = new();
//     
//     public required ISerializationContext Context { get; init; }
//     
//     public Type? GetSerializerType(Type targetType)
//     {
//         if (_cachedTypes.TryGetValue(targetType, out var serializerType))
//             return serializerType;
//         serializerType = generator.Create(targetType, Context);
//         _cachedTypes[targetType] = serializerType;
//         return serializerType;
//     }
// }
//
// public static class SerializerGeneratorCacheExtensions
// {
//     public static TContext WithGenerator<TContext>(this TContext context, SerializerGenerator generator)
//         where TContext : ISerializationContext
//     {
//         context.Providers.Add(new SerializerGeneratorCache(generator)
//         {
//             Context = context
//         });
//         return context;
//     }
// }