﻿using System.Collections.Concurrent;
using MongoDB.Bson;
using MongoDB.Bson.IO;

namespace Robotless.Modules.Serializing.Utilities;

public class SnapshotLayoutVerifier(IReadOnlyDictionary<string, Predicate<IBsonReader>> layout)
{
    public IReadOnlyDictionary<string, Predicate<IBsonReader>> Layout { get; } = layout;

    public bool IsMatch(SnapshotReader reader)
    {
        if (reader.GetCurrentBsonType() != BsonType.Document)
        {
            return false;
        }

        var initialPosition = reader.GetBookmark();
        
        reader.ReadStartDocument();
        
        var matching = true;
        foreach (var requiredField in Layout.Keys.ToHashSet())
        {
            if (reader.TryLocate(requiredField) && Layout[requiredField](reader))
                continue;
            matching = false;
            break;
        }

        reader.ReturnToBookmark(initialPosition);
        
        return matching;
    }
}