﻿namespace Robotless.Modules.Utilities;

public class ActionScope : IDisposable
{
    private readonly List<Action> _actions = [];
    
    public void Add(Action action)
    {
        _actions.Add(action);
    }

    public void Dispose()
    {
        _actions.ForEach(action => action());
    }
}