﻿namespace Robotless.Modules.Utilities;

public static class AsyncTimeout
{
    public static CancellationToken CancelAfter(TimeSpan timeout)
    {
        var source = new CancellationTokenSource();
        source.CancelAfter(timeout);
        return source.Token;
    }
    
    public static CancellationToken CancelAfter(int milliseconds)
    {
        var source = new CancellationTokenSource();
        source.CancelAfter(milliseconds);
        return source.Token;
    }
}