﻿namespace Robotless.Modules.Utilities;

public class CacheableLambda<TValue>(Func<TValue> factory)
{
    private bool _valid;
    
    private TValue? _value;
    
    public TValue Value
    {
        get
        {
            if (_valid && _value is not null)
                return _value;
            _value = factory();
            _valid = true;
            return _value;
        }
    }

    public void Reset()
    {
        _value = default;
        _valid = false;
    }
}