using System.Reflection;
using System.Reflection.Emit;
using JetBrains.Annotations;

namespace Robotless.Modules.Utilities.EmitExtensions;

public static class DynamicModule
{
    [PublicAPI]
    public static ModuleBuilder Define(AssemblyName name,
        AssemblyBuilderAccess access = AssemblyBuilderAccess.RunAndCollect)
        => AssemblyBuilder.DefineDynamicAssembly(name, access)
            .DefineDynamicModule("Manifest");

    [PublicAPI]
    public static ModuleBuilder Define(string name,
        AssemblyBuilderAccess access = AssemblyBuilderAccess.RunAndCollect)
        => Define(new AssemblyName(name), access);
}