using System.Reflection;
using System.Reflection.Emit;
using System.Runtime.CompilerServices;
using JetBrains.Annotations;

namespace Robotless.Modules.Utilities.EmitExtensions;

public class DynamicTypeCache(Func<ModuleBuilder, Type, Type> creator,
    AssemblyBuilderAccess access = AssemblyBuilderAccess.RunAndCollect,
    string moduleNamePrefix = "DynamicModule_", 
    string moduleNamePostfix = "")
{
    private readonly ConditionalWeakTable<Assembly, ModuleBuilder> _modules = new();
    
    private readonly ConditionalWeakTable<Type, Type> _types = new();

    [PublicAPI]
    public ModuleBuilder GetDynamicModule(Assembly assembly)
    {
        return _modules.GetValue(assembly, CreateDynamicModule);
        
        ModuleBuilder CreateDynamicModule(Assembly target)
        { 
            return AssemblyBuilder.DefineDynamicAssembly(
                    new AssemblyName($"{moduleNamePrefix}{target.GetName().Name}{moduleNamePostfix}"), 
                    access)
                .DefineDynamicModule("Manifest");
        }
    }

    [PublicAPI]
    public Type GetDynamicType(Type type)
        => _types.GetValue(type, target => creator(GetDynamicModule(target.Assembly), target));
}