﻿using System.Reflection;
using System.Reflection.Emit;

namespace Robotless.Modules.Utilities.EmitExtensions;

public static class EmitMetadataExtension
{
    public static void EmitTypeInfo(this ILGenerator code, Type type)
    {
        code.Emit(OpCodes.Ldtoken, type);
        code.Emit(OpCodes.Call, 
            typeof(Type).GetMethod(nameof(Type.GetTypeFromHandle))!);
    }
    
    public static void EmitFieldInfo(this ILGenerator code, FieldInfo field)
    {
        code.Emit(OpCodes.Ldtoken, field);
        code.Emit(OpCodes.Call, 
            typeof(FieldInfo).GetMethod(nameof(FieldInfo.GetFieldFromHandle), [typeof(RuntimeFieldHandle)])!);
    }
    
    public static void EmitPropertyInfo(this ILGenerator code, PropertyInfo property)
    {
        code.Emit(OpCodes.Ldtoken, property.DeclaringType!);
        code.Emit(OpCodes.Call, typeof(Type).GetMethod(nameof(Type.GetTypeFromHandle))!);
        code.Emit(OpCodes.Ldstr, property.Name);
        code.Emit(OpCodes.Ldc_I4_S, 
            (int)(BindingFlags.Instance | BindingFlags.Public | BindingFlags.NonPublic));
        code.Emit(OpCodes.Call, 
            typeof(Type).GetMethod(nameof(Type.GetProperty), [typeof(string), typeof(BindingFlags)])!);
    }
    
    public static void EmitMethodInfo(this ILGenerator code, MethodInfo method)
    {
        code.Emit(OpCodes.Ldtoken, method);
        
        if (method.DeclaringType == null)
        {
            code.Emit(OpCodes.Call, 
                typeof(MethodBase).GetMethod(nameof(MethodBase.GetMethodFromHandle), 
                    [typeof(RuntimeMethodHandle)])!);
            return;
        }
        
        code.Emit(OpCodes.Ldtoken, method.DeclaringType!);
        code.Emit(OpCodes.Call, 
            typeof(MethodBase).GetMethod(nameof(MethodBase.GetMethodFromHandle), 
                [typeof(RuntimeMethodHandle), typeof(RuntimeTypeHandle)])!);
    }
    
    public static void EmitConstructorInfo(this ILGenerator code, ConstructorInfo method)
    {
        code.Emit(OpCodes.Ldtoken, method);
        
        if (method.DeclaringType == null)
        {
            code.Emit(OpCodes.Call, 
                typeof(MethodBase).GetMethod(nameof(MethodBase.GetMethodFromHandle), 
                    [typeof(RuntimeMethodHandle)])!);
            return;
        }
        
        code.Emit(OpCodes.Ldtoken, method.DeclaringType!);
        code.Emit(OpCodes.Call, 
            typeof(MethodBase).GetMethod(nameof(MethodBase.GetMethodFromHandle), 
                [typeof(RuntimeMethodHandle), typeof(RuntimeTypeHandle)])!);
    }
}